<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exemple de Script HTML avec TensorFlow.js</title>
    <!-- Import de TensorFlow.js -->
    <script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs@3.9.0"></script>
</head>
<body>
    <h1>Exemple de Script HTML avec TensorFlow.js</h1>

    <script>
        // Import des données JSON
        const iris = /* Remplacer le chemin avec le chemin correct vers iris.json */;
        const irisTesting = /* Remplacer le chemin avec le chemin correct vers iris-testing.json */;

        // Convertir et préparer les données
        const trainingData = tf.tensor2d(iris.map(item => [
            item.sepal_length, item.sepal_width, item.petal_length, item.petal_width,
        ]));
        const outputData = tf.tensor2d(iris.map(item => [
            item.species === "setosa" ? 1 : 0,
            item.species === "virginica" ? 1 : 0,
            item.species === "versicolor" ? 1 : 0,
        ]));
        const testingData = tf.tensor2d(irisTesting.map(item => [
            item.sepal_length, item.sepal_width, item.petal_length, item.petal_width,
        ]));

        // Construction du réseau neuronal
        const model = tf.sequential();

        model.add(tf.layers.dense({
            inputShape: [4],
            activation: "sigmoid",
            units: 5,
        }));
        model.add(tf.layers.dense({
            inputShape: [5],
            activation: "sigmoid",
            units: 3,
        }));
        model.add(tf.layers.dense({
            activation: "sigmoid",
            units: 3,
        }));
        model.compile({
            loss: "meanSquaredError",
            optimizer: tf.train.adam(.06),
        });

        // Entraînement du réseau
        const startTime = Date.now();
        model.fit(trainingData, outputData, {epochs: 100})
            .then((history) => {
                model.predict(testingData).print();
            });
    </script>
</body>
</html>
